' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class _Default
  Inherits System.Web.UI.Page

  Private myBugManager As BugManager
  Private mySearchCriteria As New SearchCriteria()

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    myBugManager = New BugManager(Helpers.GetMemberId)
    ' Najpierw spawdmy, czy mamy ApplicationId i MemberId
    Helpers.CheckApplicationState(Server.UrlEncode(Page.AppRelativeVirtualPath & "?" & Request.QueryString.ToString()))
    GridView1.DataBind()
  End Sub

  Protected Sub ObjectDataSource1_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSource1.ObjectCreating
    ' Przypisz obiekt BugManager do DataSource, aby mg wywoywa jego metody.
    e.ObjectInstance = myBugManager
  End Sub

  Protected Sub ObjectDataSource1_Selecting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceSelectingEventArgs) Handles ObjectDataSource1.Selecting
    ' Przelij kryteria wyszukiwania jako parametr metody Select.
    mySearchCriteria.StatusType = lstActiveStatus.SelectedValue
    mySearchCriteria.ApplicationId = Convert.ToInt32(Session("ApplicationId"))
    e.InputParameters.Item(1) = mySearchCriteria
  End Sub

  Protected Sub GridView1_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles GridView1.DataBound
    ' Wyswietl liczb znalezionych bdw
    If myBugManager.Count > 0 Then
      If myBugManager.Count = 1 Then
        lblNumRecords.Text = "Znaleziono 1 bd"
      Else
        lblNumRecords.Text = "Liczba znalezionych bdw: " + myBugManager.Count.ToString()
      End If
    Else
      lblNumRecords.Text = "Nie znaleziono bdw"
    End If

    ' Sformatuj nasz pasek wyboru strony
    If GridView1.TopPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.TopPagerRow)
    End If
    If GridView1.BottomPagerRow IsNot Nothing Then
      Helpers.FormatGridViewPagerBar(GridView1.BottomPagerRow)
    End If

  End Sub
End Class
